function B = B(i,mi,ai,yi)

% The Bayes operator.  

%%%%%%%%%%%%%
% variables %
%%%%%%%%%%%%%

% global variables

global beta plr Pr_data x_data n NA NY NW jstate

% local variables

H = zeros(NW(n(i)),NW(n(i))); % H(wni,wnip) = Hi(wni,wnip,ai,yi)
F = zeros(1,NW(n(i)));        % F(wni) = Fi(wni,ai,yi)

%%%%%%%%%%%%%%%
% computation %
%%%%%%%%%%%%%%%

% compute F and H

for wni=1:NW(n(i)) % for each wni component
  
  for ani=1:NA(n(i)); for yni=1:NY(n(i)) % sum over these variables
      
      tmp = plr(n(i)).p(ani,wni)*Pr(i,yi,yni,ai,ani);
      
      F(wni) = F(wni) + tmp;
      
      for wnip=1:NW(n(i)) % go over each wnip for H
        
        if (plr(n(i)).wp(wni,ani,yni)==wnip) 
            H(wni,wnip) = H(wni,wnip) + tmp;
        end
        
      end
      
  end; end
  
end

% compute B
 
D = dot(mi,F);

for wnip=1:NW(n(i))

  B(wnip) = dot(mi,H(:,wnip))/D;
  
end

